#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>

using namespace std;

struct Vekt {
    long long x, y;
    int id;
    double angle;
};

const double PI = 3.14159265358979323846;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    if (!(cin >> n)) return 0;

    vector<Vekt> vecs;
    vecs.reserve(n);

    for (int i = 0; i < n; ++i) {
        long long x, y;
        cin >> x >> y;
        
        if (x == 0 && y == 0) continue;
        
        vecs.push_back({x, y, i + 1, atan2((double)y, (double)x)});
    }

    if (vecs.empty()) {
        cout << "0\n\n";
        return 0;
    }

    sort(vecs.begin(), vecs.end(), [](const Vekt& a, const Vekt& b) {
        return a.angle < b.angle;
    });

    int m = vecs.size();

    vecs.reserve(2 * m);
    for (int i = 0; i < m; ++i) {
        Vekt v = vecs[i];
        v.angle += 2 * PI;
        vecs.push_back(v);
    }

    unsigned long long max_sq_dist = 0;
    int best_start = 0;
    int best_count = 0;

    long long cur_x = 0;
    long long cur_y = 0;
    int right = 0;

    for (int left = 0; left < m; ++left) {
        while (right < 2 * m && (right == left || vecs[right].angle - vecs[left].angle < PI)) {
            cur_x += vecs[right].x;
            cur_y += vecs[right].y;
            
            unsigned long long cur_sq = (unsigned long long)abs(cur_x) * (unsigned long long)abs(cur_x) + (unsigned long long)abs(cur_y) * (unsigned long long)abs(cur_y);
            
            if (cur_sq > max_sq_dist) {
                max_sq_dist = cur_sq;
                best_start = left;
                best_count = right - left + 1;
            }
            right++;
        }

        cur_x -= vecs[left].x;
        cur_y -= vecs[left].y;
        
        if (left + 1 < right) {
             unsigned long long cur_sq = (unsigned long long)abs(cur_x) * (unsigned long long)abs(cur_x) + (unsigned long long)abs(cur_y) * (unsigned long long)abs(cur_y);
             if (cur_sq > max_sq_dist) {
                max_sq_dist = cur_sq;
                best_start = left + 1;
                best_count = right - (left + 1);
             }
        }
    }

    cout << best_count << "\n";
    for (int i = 0; i < best_count; ++i) {
        cout << vecs[best_start + i].id << (i == best_count - 1 ? "" : " ");
    }
    cout << "\n";

    return 0;
}